// Variable Death Messages by Steve Streeting


#include "g_local.h"
#include "g_messages.h"
#include <io.h>
#include <FCNTL.H>

int  MsgMod = 0;
char MsgStrings[40][100];
char MsgVars[40][5];

//
//
void MsgModSetup(void)
{
	int file, i;
	char file_name[256];
	cvar_t *game_dir;
	
	game_dir = gi.cvar ("game", "", 0);
	sprintf(file_name,".\\%s\\msg.txt",game_dir->string);

	file = _open(file_name,_O_RDONLY | _O_TEXT);
	MsgMod = 0;
	i = 0;
	if (file != -1)
	{
		long file_size;
		char *p_buffer;
		char *p_name;
		long counter = 0;
		int n_chars = 0;

		file_size = _filelength(file);
		p_buffer = malloc(file_size);
		memset(p_buffer,0,file_size);

		file_size = _read(file, (void *)p_buffer, file_size);

		gi.dprintf("Reading messages from msg.txt.\n");

		p_name = p_buffer;
		do
		{
			// Get message string
			while (*p_name != '\r' && *p_name != '\n' && counter < file_size)
			{
				n_chars++;
				counter++;
				p_name++;
			}
			if (n_chars)
			{
				memcpy(&MsgStrings[i][0], p_name - n_chars, n_chars);
				memset(&MsgStrings[i][n_chars], 0, 1);
				n_chars = 0;

			}
			counter++;
			p_name++;
			n_chars=0;
			while (*p_name != '\r' && *p_name != '\n' && counter < file_size)
			{
				n_chars++;
				counter++;
				p_name++;
			}
			if (n_chars)
			{
				memcpy(&MsgVars[i][0], p_name - n_chars, n_chars);
				memset(&MsgVars[i][n_chars], 0, 1);
				n_chars = 0;
			}
			counter++;
			p_name++;
			i++;

		} while (counter < file_size);

		free(p_buffer);
		_close(file);

		MsgMod = true;
		gi.dprintf("%i messages.\n",i);
			
	}


}

void GetMsgString(int Cause, char* Victim, 
						char* Attacker, char* Message)
{
	int NumVars, Var;
	char NameStr[2][50];

		

	
	
	NumVars = strlen(MsgVars[Cause]);

	Var = 0;
	while (Var < NumVars)
	{
		if (MsgVars[Cause][Var] == 'v')
			sprintf(NameStr[Var],Victim);
		else
			sprintf(NameStr[Var],Attacker);
		// Change colour of names
		ChangeTextColour(NameStr[Var]);

		Var++;
	}


	if (!NumVars)
		sprintf(Message, MsgStrings[Cause]);
	else if (NumVars == 1)
		sprintf(Message,MsgStrings[Cause],NameStr[0]);
	else // (NumVars == 2)
		sprintf(Message,MsgStrings[Cause],NameStr[0], NameStr[1]);
	
	//strcat(Message, "\n");


}

void ChangeTextColour(char *text)
{

	int i;

	for (i = 0; i < strlen(text) ; i ++)
		text[i] |= 128;


}
